/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include <stdarg.h>

#include "lx.h"
#include "lx_map_file.h"
#include "lx_routing.h"
#include "lx_route_file.h"

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx__lib_types.h"
#include "mx_raw.h"
#include "mx__lib.h"
#include "mx__driver_interface.h"
#include <errno.h>
lx_t lx;
int mi_verbose_flag;
int mi_is_demon;
FILE*out_fp;
char*daemon_pid_filename;
char*map_filenames [MI_MY_SIZE];

int lx_map_print (lx_t*lx, lx_map_t*m)
{
  return 0; 
}
void lx_mapper_main (lx_t*lx)
{
}

static void usage (char*s)
{
  fprintf (stderr, "usage: %s <map file> <unit> [<route file>]\n", s);
  exit (1);
}

static void 
mx_macaddr_to_nic_id(uint8_t mac_address[6], uint64_t *nic_id)
{
  uint32_t mac_low32;
  uint16_t mac_high16;

  /* convert to mx mac address */
  mac_low32 = ((int)mac_address[5]) & 0xff;
  mac_low32 |= ((int)mac_address[4] & 0xff) << 8;
  mac_low32 |= ((int)mac_address[3] & 0xff) << 16;
  mac_low32 |= ((int)mac_address[2] & 0xff) << 24;
  mac_high16 = (int)mac_address[1] & 0xff;
  mac_high16 |= ((int)mac_address[0] & 0xff) << 8;

  *nic_id = mac_low32;
  *nic_id |= (uint64_t) mac_high16 << 32LL;
}

static void
mx_nic_id_to_macaddr(uint64_t nic_id, uint8_t macaddr[6])
{
  int i;

  for (i = 0; i < 6; i++) {
    macaddr[5 - i] = (uint8_t)((nic_id >> (i * 8)) & 0xff);
  }
  
}

int main (int argc, char*argv [])
{
  lx_map_t*m;
  FILE*fp;
  lx_node_t*first;
  int index, unit, i, j, k, o, from, num_hosts, num_ports, num_routes, line_count, last_port;
  lx_route_table_entry_t*entries, *e;
  int r;
  mx_raw_endpoint_t raw_endpt;
  uint8_t mac_address [6];
  signed char hops [LX_ROUTE_SIZE];
  lx_node_t*me;
  uint64_t nic_id, destination;
  
  mi_is_demon = 0;
  mi_verbose_flag = 0;
  out_fp = 0;
  daemon_pid_filename = 0;

  if (argc < 3)
    usage (argv [0]);
  
  unit = atoi (argv [2]);

  mx_init();
  mx_set_error_handler(MX_ERRORS_RETURN);
  r = mx_board_number_to_nic_id(unit, &nic_id);
  if (r != MX_SUCCESS) 
  {
    fprintf (stderr, "board id %d can't be found:%s \n", 
	     unit, mx_strerror(r));
    exit(1);
  }
  
  r = mx_raw_open_endpoint(unit, NULL, 0, &raw_endpt);
  if (r != MX_SUCCESS)
  {
    fprintf (stderr, "couldn't open raw endpoint for unit %d\n", unit);
    exit(1);
  }
  
  mx_nic_id_to_macaddr(nic_id, mac_address);

  if (!(fp = fopen (argv [1], "r")))
  {
    fprintf (stderr, "couldn't open %s\n", argv [1]);
    usage (argv [0]);
  }
  
  lx_init (&lx);
  
  if (!lx_map_file_read (fp, &lx.maps [0], &first))
  {
    fprintf (stderr, "lx_map_file_read () failed\n");
    return 0;
  }

  m = lx.maps;
  fprintf (stderr, "%d hosts and %d xbars\n", m->num_hosts, m->num_xbars);

  if (!(me = lx_seen (m, mac_address)))
  {
    fprintf (stderr, lx_mac_format " not found in %s", lx_mac_args (mac_address), argv [1]);
    return 0;
  }  

  if (!(fp = argc == 2 ? stdin : fopen (argv [3], "r")))
  {
    fprintf (stderr, "couldn't open %s", argv [3]);
    usage (argv [0]);
  }
  
  line_count = 0;

  r = mx_raw_set_route_begin(raw_endpt);
  if (r) 
  {
    perror ("mx_raw_set_route_begin failed");
    if (errno == EBUSY)
      fprintf (stderr, "The mapper is currently running on board %d.  "
	       "It must be paused or killed\n", unit);      
    return 0;
  }

  
  while ((entries = lx_route_file_read_routes (fp, &from, &num_hosts, &num_ports, &num_routes, &line_count)))
  {
    insist (from >= 0 && from < m->num_hosts);
    insist (num_hosts == m->num_hosts);
    insist (num_ports > 0 && num_ports <= LX_HOST_SIZE);
    insist (num_routes > 0); 

    if (from == me->index)
    {
      for (i = 0; i < num_hosts; i++)
      {
	index = 0;
	
	for (k = 0; k < num_routes; k++)
	{
	  for (j = 0; j < num_ports; j++)
	  {
	    for (o = 0; o < num_ports; o++)
	    {
	      
	      e = lx_route_file_entry (entries, num_ports, num_hosts, num_routes, j, i, o, k);
	      insist (e);
	    
	      if (e->valid)
	      {
		insist (lx_follow (me, j, &e->route, &last_port) == m->host_array [i] && last_port == o);

		mi_memcpy (hops, e->route.hops, e->route.length);
		lx_physical_route (hops, e->route.length);
		mx_macaddr_to_nic_id(lx_host_c 
				     (m->host_array [i])->mac_address,
				     &destination);
		r = mx_raw_set_route(raw_endpt,  destination, 
				     hops, e->route.length, 
				     0, j, MX_HOST_MX);
		insist (r == 0);
	      }
	    }
	  }
	}
	/*	next_node:;*/
      }
      free (entries);
      r = mx_raw_set_route_end(raw_endpt);
      insist (r == 0);
      return 0;
    }
  }

  fprintf (stderr, lx_mac_format " not found in routes file", lx_mac_args (mac_address));

  fclose (fp);
  fp = stdout;
  except: return 1;
}
